if not location.generate_copy and location.generate_target then
  error("location.generate_copy and location.generate_target need to be set.")
end
local square = {
  Place.new(CellView.new(Vector.new(0, 0)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(1, 0)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(0, 1)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(1, 1)), Basic.new(1)),
  Join.new(CellFace.new(Vector.new(0, 0), UP)),
  Join.new(CellFace.new(Vector.new(0, 0), RIGHT)),
  Join.new(CellFace.new(Vector.new(1, 0), UP)),
  Join.new(CellFace.new(Vector.new(0, 1), RIGHT))
};
local triangle = {
  Place.new(CellView.new(Vector.new(0, 0)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(1, 0)), Basic.new(1)),
  Place.new(CellView.new(Vector.new(0, 1)), Basic.new(1)),
  Join.new(CellFace.new(Vector.new(0, 0), UP)),
  Join.new(CellFace.new(Vector.new(0, 0), RIGHT))
};

local generate_copy = location.generate_copy
local generate_target = location.generate_target

local function build_source_object(is_square)
  destroy_rectangle(generate_copy)
  local choice = nil
  if is_square then
    choice = square
  else
    choice = triangle
  end
  game:interact(transform_interaction_table(choice, CoordinateTransform.new(generate_copy.lesser)))
  game:interact(transform_interaction_table(choice, CoordinateTransform.new(generate_target.lesser)))
end
local generate_sequence = {
  false,
  true,
  false,
  false,
  true,
  false,
  false,
  true,
  false,
  true,
  true,
  true,
  true,
  false,
  true,
  false,
  false,
  true,
  true,
  true,
  true,
  false,
  true,
  true,
  true,
  false,
  true,
  false,
  false,
  false,
  false,
  false,
  false,
  true,
  true,
  false,
  true,
  false,
  false,
  true
};
local generate_index = 0;
local function is_square(idx)
  return generate_sequence[(idx % #generate_sequence) + 1]
end
destroy_rectangle(generate_target)
game:each_step(function()
  if rectangle_empty(generate_target) then
    build_source_object(is_square(generate_index))
    generate_index = generate_index + 1
  end
end)
